/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.item;

import doggytalents.DoggyAccessories;
import doggytalents.DoggyAccessoryTypes;
import doggytalents.DoggyEntityTypes;
import doggytalents.DoggyItems;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.inferface.IDogItem;
import doggytalents.api.registry.Accessory;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.accessory.DyeableAccessory;
import doggytalents.common.entity.misc.DogPlushie;
import doggytalents.common.item.IDyeableArmorItem;
import doggytalents.common.util.ItemUtil;
import doggytalents.common.variant.DogVariant;
import doggytalents.common.variant.util.DogVariantUtil;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class DogPlushieItem
extends Item
implements IDyeableArmorItem,
IDogItem {
    public DogPlushieItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_ || !(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        BlockState state = level.m_8055_(pos);
        BlockPos spawnAt = state.m_60812_((BlockGetter)level, pos).m_83281_() ? pos : pos.m_121945_(face);
        DogPlushie plush = (DogPlushie)((EntityType)DoggyEntityTypes.DOG_PLUSHIE_TOY.get()).m_262451_((ServerLevel)level, null, null, spawnAt, MobSpawnType.TRIGGERED, !Objects.equals(pos, spawnAt) && face == Direction.UP, false);
        if (plush != null) {
            plush.m_146922_(face.m_122424_().m_122435_());
            int color = this.m_41121_(stack);
            plush.setCollarColor(color);
            DogVariant variant = DogPlushieItem.getDogVariant(stack);
            plush.setDogVariant(variant);
            boolean collar_thicc = DogPlushieItem.getCollarThicc(stack);
            plush.setCollarThicc(collar_thicc);
            level.m_7967_((Entity)plush);
        }
        if (player != null && !player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        if (player != null) {
            player.m_36335_().m_41524_((Item)this, 20);
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flags) {
        boolean is_thicc_collar;
        if (level == null) {
            return;
        }
        String desc_id = "item.doggytalents.dog_plushie_toy_item.description";
        components.add((Component)Component.m_237115_((String)desc_id).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
        DogVariant variant = DogPlushieItem.getDogVariant(stack);
        if (variant != DogVariantUtil.getDefault() && level.f_46443_) {
            String variant_str = Component.m_237115_((String)"doggui.classical.variant").getString() + " " + ClientEventHandler.getTranslatedVariantStr(variant);
            MutableComponent variant_c1 = Component.m_237113_((String)variant_str).m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(variant.guiColor()));
            components.add((Component)variant_c1);
        }
        if (is_thicc_collar = DogPlushieItem.getCollarThicc(stack)) {
            components.add((Component)Component.m_237115_((String)DoggyItems.WOOL_COLLAR_THICC.get().m_5524_()).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true))));
        }
    }

    @Override
    public int getDefaultColor(ItemStack stack) {
        return 11546150;
    }

    public static void setDogVariant(ItemStack stack, DogVariant variant) {
        if (stack.m_41720_() != DoggyItems.DOG_PLUSHIE_TOY.get()) {
            return;
        }
        CompoundTag tag = ItemUtil.getTag(stack);
        tag.m_128359_("dogVariant", DogVariantUtil.toSaveString(variant));
        ItemUtil.putTag(stack, tag);
    }

    public static DogVariant getDogVariant(ItemStack stack) {
        if (stack.m_41720_() != DoggyItems.DOG_PLUSHIE_TOY.get()) {
            return DogVariantUtil.getDefault();
        }
        CompoundTag tag = ItemUtil.getTag(stack);
        if (!tag.m_128425_("dogVariant", 8)) {
            return DogVariantUtil.getDefault();
        }
        String variant_str = tag.m_128461_("dogVariant");
        return DogVariantUtil.fromSaveString(variant_str);
    }

    public static void setCollarThicc(ItemStack stack, boolean val) {
        if (stack.m_41720_() != DoggyItems.DOG_PLUSHIE_TOY.get()) {
            return;
        }
        CompoundTag tag = ItemUtil.getTag(stack);
        tag.m_128379_("collarThicc", val);
        ItemUtil.putTag(stack, tag);
    }

    public static boolean getCollarThicc(ItemStack stack) {
        if (stack.m_41720_() != DoggyItems.DOG_PLUSHIE_TOY.get()) {
            return false;
        }
        CompoundTag tag = ItemUtil.getTag(stack);
        return tag.m_128471_("collarThicc");
    }

    @Override
    public InteractionResult processInteract(AbstractDog dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!(dogIn instanceof Dog)) {
            return InteractionResult.PASS;
        }
        Dog dog = (Dog)dogIn;
        ItemStack stack = playerIn.m_21120_(handIn);
        if (this.copyDogToStack(dog, stack, playerIn.m_6144_())) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private boolean copyDogToStack(Dog dog, ItemStack stack, boolean copy_color) {
        boolean collar_thicc_stack;
        boolean collar_thicc_dog;
        DogVariant variant_stack;
        boolean changed = false;
        DogVariant variant_dog = dog.dogVariant();
        if (variant_dog != (variant_stack = DogPlushieItem.getDogVariant(stack))) {
            if (!dog.m_9236_().f_46443_) {
                DogPlushieItem.setDogVariant(stack, variant_dog);
            }
            changed = true;
        }
        if ((collar_thicc_dog = dog.getAccessory((Accessory)DoggyAccessories.DYEABLE_COLLAR_THICC.get()).isPresent()) != (collar_thicc_stack = DogPlushieItem.getCollarThicc(stack))) {
            if (!dog.m_9236_().f_46443_) {
                DogPlushieItem.setCollarThicc(stack, collar_thicc_dog);
            }
            changed = true;
        }
        if (copy_color && this.copyCollarColor(dog, stack)) {
            return true;
        }
        return changed;
    }

    private boolean copyCollarColor(Dog dog, ItemStack stack) {
        int collar_color_stack = ItemUtil.getDyeColorForStack(stack);
        int collar_color_dog = dog.getAccessory(DoggyAccessoryTypes.COLLAR.get()).filter(x -> x instanceof DyeableAccessory.DyeableAccessoryInstance).map(x -> ((DyeableAccessory.DyeableAccessoryInstance)x).getColorInteger()).orElse(this.getDefaultColor(stack));
        if (collar_color_dog == collar_color_stack) {
            return false;
        }
        ItemUtil.setDyeColorForStack(stack, collar_color_dog);
        return true;
    }
}

